﻿using StokYonetimSistemi.Business;
using StokYonetimSistemi.Entities;
using System;
using System.Windows.Forms;

namespace StokYonetimSistemi.WinFormsUI
{
    public partial class frmUrunYonetimi : Form
    {
        private readonly UrunManager _urunManager = new UrunManager();
        private readonly KategoriManager _kategoriManager = new KategoriManager();

        public frmUrunYonetimi()
        {
            InitializeComponent();
        }

        private void frmUrunYonetimi_Load(object sender, EventArgs e)
        {
            KategorileriDoldur();
            UrunleriListele();
        }

        private void KategorileriDoldur()
        {
            try
            {
                cmbKategori.DataSource = _kategoriManager.TumKategorileriGetir();
                cmbKategori.DisplayMember = "Ad";
                cmbKategori.ValueMember = "Id";
            }
            catch (Exception ex)
            {
                MessageBox.Show("Kategoriler yüklenirken bir hata oluştu: " + ex.Message, "Hata", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void UrunleriListele()
        {
            try
            {
                dgvUrunler.DataSource = _urunManager.TumUrunleriGetir();
                dgvUrunler.Columns["StokHareketleri"].Visible = false;
            }
            catch (Exception ex)
            {
                MessageBox.Show("Ürünler listelenirken bir hata oluştu: " + ex.Message, "Hata", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void btnEkle_Click(object sender, EventArgs e)
        {
            if (!ValidateInputs()) return;

            try
            {
                var yeniUrun = new Urun
                {
                    Ad = txtAd.Text,
                    Marka = txtMarka.Text,
                    Model = txtModel.Text,
                    Barkod = txtBarkod.Text,
                    AlisFiyati = decimal.Parse(txtAlisFiyati.Text),
                    SatisFiyati = decimal.Parse(txtSatisFiyati.Text),
                    StokAdedi = 0,
                    AktifMi = chkAktifMi.Checked,
                    KategoriId = (int)cmbKategori.SelectedValue
                };

                _urunManager.UrunEkle(yeniUrun);
                UrunleriListele();
                MessageBox.Show("Ürün başarıyla eklendi.", "Başarılı", MessageBoxButtons.OK, MessageBoxIcon.Information);
                Temizle();
            }
            catch (Exception ex)
            {
                MessageBox.Show("Ekleme sırasında hata oluştu: " + ex.Message, "Hata", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void btnGuncelle_Click(object sender, EventArgs e)
        {
            if (dgvUrunler.CurrentRow == null)
            {
                MessageBox.Show("Lütfen güncellenecek bir ürün seçin.", "Uyarı", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }
            if (!ValidateInputs()) return;

            try
            {
                int seciliId = (int)dgvUrunler.CurrentRow.Cells["Id"].Value;

                var guncellenecekUrun = new Urun
                {
                    Id = seciliId,
                    Ad = txtAd.Text,
                    Marka = txtMarka.Text,
                    Model = txtModel.Text,
                    Barkod = txtBarkod.Text,
                    AlisFiyati = decimal.Parse(txtAlisFiyati.Text),
                    SatisFiyati = decimal.Parse(txtSatisFiyati.Text),
                    StokAdedi = (int)dgvUrunler.CurrentRow.Cells["StokAdedi"].Value,
                    AktifMi = chkAktifMi.Checked,
                    KategoriId = (int)cmbKategori.SelectedValue
                };

                _urunManager.UrunGuncelle(guncellenecekUrun);
                UrunleriListele();
                MessageBox.Show("Ürün başarıyla güncellendi.", "Başarılı", MessageBoxButtons.OK, MessageBoxIcon.Information);
                Temizle();
            }
            catch (Exception ex)
            {
                MessageBox.Show("Güncelleme sırasında hata oluştu: " + ex.Message, "Hata", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void btnSil_Click(object sender, EventArgs e)
        {
            if (dgvUrunler.CurrentRow == null)
            {
                MessageBox.Show("Lütfen silinecek bir ürün seçin.", "Uyarı", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }

            if (MessageBox.Show("Seçili ürünü silmek istediğinize emin misiniz?", "Silme Onayı", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == DialogResult.Yes)
            {
                try
                {
                    int seciliId = (int)dgvUrunler.CurrentRow.Cells["Id"].Value;
                    _urunManager.UrunSil(seciliId);
                    UrunleriListele();
                    MessageBox.Show("Ürün başarıyla silindi.", "Başarılı", MessageBoxButtons.OK, MessageBoxIcon.Information);
                    Temizle();
                }
                catch (Exception ex)
                {
                    MessageBox.Show("Silme sırasında hata oluştu: " + ex.Message, "Hata", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
        }

        private void btnTemizle_Click(object sender, EventArgs e)
        {
            Temizle();
        }

        private void dgvUrunler_CellClick(object sender, DataGridViewCellEventArgs e)
        {
            if (e.RowIndex >= 0 && dgvUrunler.CurrentRow != null)
            {
                txtAd.Text = dgvUrunler.CurrentRow.Cells["Ad"].Value.ToString();
                txtMarka.Text = dgvUrunler.CurrentRow.Cells["Marka"].Value?.ToString();
                txtModel.Text = dgvUrunler.CurrentRow.Cells["Model"].Value?.ToString();
                txtBarkod.Text = dgvUrunler.CurrentRow.Cells["Barkod"].Value?.ToString();
                txtAlisFiyati.Text = dgvUrunler.CurrentRow.Cells["AlisFiyati"].Value?.ToString() ?? "0";
                txtSatisFiyati.Text = dgvUrunler.CurrentRow.Cells["SatisFiyati"].Value.ToString();
                chkAktifMi.Checked = (bool)dgvUrunler.CurrentRow.Cells["AktifMi"].Value;
                cmbKategori.SelectedValue = dgvUrunler.CurrentRow.Cells["KategoriId"].Value;
            }
        }

        private void Temizle()
        {
            txtAd.Clear();
            txtMarka.Clear();
            txtModel.Clear();
            txtBarkod.Clear();
            txtAlisFiyati.Text = "0";
            txtSatisFiyati.Text = "0";
            chkAktifMi.Checked = true;
            if (cmbKategori.Items.Count > 0)
                cmbKategori.SelectedIndex = 0;

            dgvUrunler.ClearSelection();
        }

        private bool ValidateInputs()
        {
            if (string.IsNullOrWhiteSpace(txtAd.Text))
            {
                MessageBox.Show("Ürün adı boş bırakılamaz.", "Uyarı", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return false;
            }
            if (cmbKategori.SelectedValue == null)
            {
                MessageBox.Show("Lütfen bir kategori seçin.", "Uyarı", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return false;
            }
            if (!decimal.TryParse(txtAlisFiyati.Text, out _) || !decimal.TryParse(txtSatisFiyati.Text, out _))
            {
                MessageBox.Show("Fiyat alanları sayısal bir değer olmalıdır.", "Uyarı", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return false;
            }
            return true;
        }
    }
}